/*
 * Decompiled with CFR 0.152.
 */
package cc.iotkit.comp.DLT645.analysis;

import cc.iotkit.comp.DLT645.analysis.DLT645Data;
import cc.iotkit.comp.DLT645.analysis.DLT645DataFormat;
import cc.iotkit.comp.DLT645.analysis.DLT645V1997Data;
import cn.hutool.core.text.csv.CsvReader;
import cn.hutool.core.text.csv.CsvUtil;
import cn.hutool.core.util.CharsetUtil;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class DLT645v1997CsvLoader {
    public List<DLT645Data> loadCsvFile() {
        CsvReader csvReader = CsvUtil.getReader();
        InputStreamReader dataReader = new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("DLT645-1997.csv"), CharsetUtil.CHARSET_GBK);
        List rows = csvReader.read((Reader)dataReader, JDecoderValueParam.class);
        ArrayList<DLT645Data> list = new ArrayList<DLT645Data>();
        for (JDecoderValueParam jDecoderValueParam : rows) {
            try {
                DLT645V1997Data entity = new DLT645V1997Data();
                entity.setName(jDecoderValueParam.getName());
                entity.setDi1h((byte)Integer.parseInt(jDecoderValueParam.di1h, 16));
                entity.setDi1l((byte)Integer.parseInt(jDecoderValueParam.di1l, 16));
                entity.setDi0h((byte)Integer.parseInt(jDecoderValueParam.di0h, 16));
                entity.setDi0l((byte)Integer.parseInt(jDecoderValueParam.di0l, 16));
                entity.setLength(jDecoderValueParam.length);
                entity.setUnit(jDecoderValueParam.unit);
                entity.setRead(Boolean.parseBoolean(jDecoderValueParam.read));
                entity.setWrite(Boolean.parseBoolean(jDecoderValueParam.write));
                DLT645DataFormat format = new DLT645DataFormat();
                if (!format.decodeFormat(jDecoderValueParam.format, jDecoderValueParam.length)) {
                    System.out.println("DLT645 CSV\u8bb0\u5f55\u7684\u683c\u5f0f\u9519\u8bef:" + jDecoderValueParam.getName() + ":" + jDecoderValueParam.getFormat());
                    continue;
                }
                entity.setFormat(format);
                list.add(entity);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public static class JDecoderValueParam
    implements Serializable {
        private String di1h;
        private String di1l;
        private String di0h;
        private String di0l;
        private String format;
        private Integer length;
        private String unit;
        private String read;
        private String write;
        private String name;

        public String getDi1h() {
            return this.di1h;
        }

        public String getDi1l() {
            return this.di1l;
        }

        public String getDi0h() {
            return this.di0h;
        }

        public String getDi0l() {
            return this.di0l;
        }

        public String getFormat() {
            return this.format;
        }

        public Integer getLength() {
            return this.length;
        }

        public String getUnit() {
            return this.unit;
        }

        public String getRead() {
            return this.read;
        }

        public String getWrite() {
            return this.write;
        }

        public String getName() {
            return this.name;
        }

        public void setDi1h(String di1h) {
            this.di1h = di1h;
        }

        public void setDi1l(String di1l) {
            this.di1l = di1l;
        }

        public void setDi0h(String di0h) {
            this.di0h = di0h;
        }

        public void setDi0l(String di0l) {
            this.di0l = di0l;
        }

        public void setFormat(String format) {
            this.format = format;
        }

        public void setLength(Integer length) {
            this.length = length;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }

        public void setRead(String read) {
            this.read = read;
        }

        public void setWrite(String write) {
            this.write = write;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JDecoderValueParam)) {
                return false;
            }
            JDecoderValueParam other = (JDecoderValueParam)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$length = this.getLength();
            Integer other$length = other.getLength();
            if (this$length == null ? other$length != null : !((Object)this$length).equals(other$length)) {
                return false;
            }
            String this$di1h = this.getDi1h();
            String other$di1h = other.getDi1h();
            if (this$di1h == null ? other$di1h != null : !this$di1h.equals(other$di1h)) {
                return false;
            }
            String this$di1l = this.getDi1l();
            String other$di1l = other.getDi1l();
            if (this$di1l == null ? other$di1l != null : !this$di1l.equals(other$di1l)) {
                return false;
            }
            String this$di0h = this.getDi0h();
            String other$di0h = other.getDi0h();
            if (this$di0h == null ? other$di0h != null : !this$di0h.equals(other$di0h)) {
                return false;
            }
            String this$di0l = this.getDi0l();
            String other$di0l = other.getDi0l();
            if (this$di0l == null ? other$di0l != null : !this$di0l.equals(other$di0l)) {
                return false;
            }
            String this$format = this.getFormat();
            String other$format = other.getFormat();
            if (this$format == null ? other$format != null : !this$format.equals(other$format)) {
                return false;
            }
            String this$unit = this.getUnit();
            String other$unit = other.getUnit();
            if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
                return false;
            }
            String this$read = this.getRead();
            String other$read = other.getRead();
            if (this$read == null ? other$read != null : !this$read.equals(other$read)) {
                return false;
            }
            String this$write = this.getWrite();
            String other$write = other.getWrite();
            if (this$write == null ? other$write != null : !this$write.equals(other$write)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof JDecoderValueParam;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $length = this.getLength();
            result = result * 59 + ($length == null ? 43 : ((Object)$length).hashCode());
            String $di1h = this.getDi1h();
            result = result * 59 + ($di1h == null ? 43 : $di1h.hashCode());
            String $di1l = this.getDi1l();
            result = result * 59 + ($di1l == null ? 43 : $di1l.hashCode());
            String $di0h = this.getDi0h();
            result = result * 59 + ($di0h == null ? 43 : $di0h.hashCode());
            String $di0l = this.getDi0l();
            result = result * 59 + ($di0l == null ? 43 : $di0l.hashCode());
            String $format = this.getFormat();
            result = result * 59 + ($format == null ? 43 : $format.hashCode());
            String $unit = this.getUnit();
            result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
            String $read = this.getRead();
            result = result * 59 + ($read == null ? 43 : $read.hashCode());
            String $write = this.getWrite();
            result = result * 59 + ($write == null ? 43 : $write.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "DLT645v1997CsvLoader.JDecoderValueParam(di1h=" + this.getDi1h() + ", di1l=" + this.getDi1l() + ", di0h=" + this.getDi0h() + ", di0l=" + this.getDi0l() + ", format=" + this.getFormat() + ", length=" + this.getLength() + ", unit=" + this.getUnit() + ", read=" + this.getRead() + ", write=" + this.getWrite() + ", name=" + this.getName() + ")";
        }
    }
}

