/*
 * Decompiled with CFR 0.152.
 */
package cc.iotkit.comp.mqtt;

import cc.iotkit.common.thing.ThingService;
import cc.iotkit.comp.mqtt.IScripter;
import cc.iotkit.comp.mqtt.TransparentMsg;
import cc.iotkit.model.device.message.ThingModelMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.script.CompiledScript;
import javax.script.ScriptEngineManager;
import javax.script.SimpleBindings;
import org.apache.commons.beanutils.BeanUtils;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.script.LuaScriptEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuaScripter
implements IScripter {
    private static final Logger log = LoggerFactory.getLogger(LuaScripter.class);
    private final LuaScriptEngine engine = (LuaScriptEngine)new ScriptEngineManager().getEngineByName("luaj");
    private LuaValue decoder;
    private LuaValue encoder;

    @Override
    public void setScript(String script) {
        try {
            CompiledScript compiledScript = this.engine.compile(script);
            SimpleBindings bindings = new SimpleBindings();
            compiledScript.eval(bindings);
            this.decoder = (LuaValue)bindings.get("decode");
            this.encoder = (LuaValue)bindings.get("encode");
        }
        catch (Throwable e) {
            log.error("compile script error", e);
        }
    }

    @Override
    public ThingModelMessage decode(TransparentMsg msg) {
        try {
            LuaTable table = new LuaTable();
            table.set("model", msg.getModel());
            table.set("mac", msg.getMac());
            table.set("data", msg.getData());
            Map result = (Map)this.parse(this.decoder.call(table));
            ThingModelMessage modelMessage = new ThingModelMessage();
            BeanUtils.populate((Object)modelMessage, (Map)result);
            modelMessage.setProductKey(msg.getProductKey());
            modelMessage.setDeviceName(msg.getMac());
            return modelMessage;
        }
        catch (Throwable e) {
            log.error("execute decode script error", e);
            return null;
        }
    }

    @Override
    public TransparentMsg encode(ThingService<?> service) {
        try {
            LuaTable table = new LuaTable();
            table.set("identifier", service.getIdentifier());
            table.set("type", service.getType());
            table.set("productKey", service.getProductKey());
            table.set("deviceName", service.getDeviceName());
            table.set("mid", service.getMid());
            Object params = service.getParams();
            LuaTable tableParams = new LuaTable();
            if (params instanceof Map) {
                ((Map)params).forEach((key, val) -> tableParams.set(key.toString(), this.parse(val)));
            }
            table.set("params", (LuaValue)tableParams);
            LuaValue result = this.encoder.call(table);
            Map map = (Map)this.parse(result);
            TransparentMsg message = new TransparentMsg();
            BeanUtils.populate((Object)message, (Map)map);
            return message;
        }
        catch (Throwable e) {
            log.error("execute encode script error", e);
            return null;
        }
    }

    private Object parse(LuaValue value) {
        String type2;
        switch (type2 = value.typename()) {
            case "string": {
                return value.toString();
            }
            case "number": 
            case "int": {
                return value.toint();
            }
            case "table": {
                HashMap<String, Object> data = new HashMap<String, Object>();
                LuaTable table = (LuaTable)value;
                int arrLen = table.rawlen();
                if (arrLen > 0) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    for (LuaValue key : table.keys()) {
                        list.add(this.parse(table.get(key)));
                    }
                    return list;
                }
                for (LuaValue key : table.keys()) {
                    data.put(key.toString(), this.parse(table.get(key)));
                }
                return data;
            }
        }
        return null;
    }

    private LuaValue parse(Object value) {
        if (value instanceof String) {
            return LuaValue.valueOf(value.toString());
        }
        if (value instanceof Integer) {
            return LuaValue.valueOf((Integer)value);
        }
        return new LuaTable();
    }
}

